package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * risk_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum RiskHandleStatus {

    _0("0", "待处理"),
    _1("1", "已处理"),
    _2("2", "风险变更");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RiskHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RiskHandleStatus fromCode(String code) {
        return Stream.of(RiskHandleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
