package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum TaxRateType {

    _0("0", "非0税率"),
    _1("1", "出口退税"),
    _2("2", "免税"),
    _3("3", "不征税"),
    _4("4", "普通0税率"),
    _5("5", "差额征税");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxRateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRateType fromCode(String code) {
        return Stream.of(TaxRateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
