package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * withholding_auth_use
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum WithholdingAuthUse {

    _1("1", "抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WithholdingAuthUse(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WithholdingAuthUse fromCode(String code) {
        return Stream.of(WithholdingAuthUse.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
