package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceVerifyTask;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IInvoiceVerifyTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票验真请求记录前端控制器
 *
 * @author ultraman
 * @date 2022-12-14
 */
@RestController
public class InvoiceVerifyTaskController {

  @Autowired
  private IInvoiceVerifyTaskService invoiceVerifyTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceVerifyTask 发票验真请求记录
   * @return
   */
  @GetMapping("/invoiceverifytasks" )
  public XfR getInvoiceVerifyTasks(XfPage page, InvoiceVerifyTask invoiceVerifyTask) {
    return XfR.ok(invoiceVerifyTaskServiceImpl.page(page, Wrappers.query(invoiceVerifyTask)));
  }

  /**
   * 通过id查询发票验真请求记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceverifytasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyTaskServiceImpl.getById(id));
  }

  /**
   * 新增发票验真请求记录
   * @param invoiceVerifyTask 发票验真请求记录
   * @return XfR
   */
  @PostMapping("/invoiceverifytasks")
  public XfR save(@RequestBody InvoiceVerifyTask invoiceVerifyTask) {
     return XfR.ok(invoiceVerifyTaskServiceImpl.save(invoiceVerifyTask));
  }

  /**
   * 修改-传入修改后的全部数据发票验真请求记录
   * @param invoiceVerifyTask 发票验真请求记录
   * @return XfR
   */
  @PutMapping("/invoiceverifytasks/{id}")
  public XfR putUpdate(@RequestBody InvoiceVerifyTask invoiceVerifyTask,@PathVariable Long id) {
      invoiceVerifyTask.setId(id);
      return XfR.ok(invoiceVerifyTaskServiceImpl.updateById(invoiceVerifyTask));
  }

  /**
   * 修改-传入修改的数据发票验真请求记录
   * @param invoiceVerifyTask 发票验真请求记录
   * @return XfR
   */
  @PatchMapping("/invoiceverifytasks/{id}")
  public XfR patchUpdate(@RequestBody InvoiceVerifyTask invoiceVerifyTask,@PathVariable Long id) {
      InvoiceVerifyTask upinvoiceVerifyTask = invoiceVerifyTaskServiceImpl.getById(id);
      if(upinvoiceVerifyTask != null){
        upinvoiceVerifyTask = ObjectCopyUtils.copyProperties(invoiceVerifyTask,upinvoiceVerifyTask,true);
      }
      return XfR.ok(invoiceVerifyTaskServiceImpl.updateById(upinvoiceVerifyTask));
  }

  /**
   * 通过id删除发票验真请求记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceverifytasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceVerifyTaskServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceverifytasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_verify_task");
     params.put("request", condition);

     return XfR.ok(invoiceVerifyTaskServiceImpl.querys(params));
  }

}
