package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.CustomsPayment;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.ICustomsPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 海关缴款书主信息前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class CustomsPaymentController {

  @Autowired
  private ICustomsPaymentService customsPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsPayment 海关缴款书主信息
   * @return
   */
  @GetMapping("/customspayments" )
  public XfR getCustomsPayments(XfPage page, CustomsPayment customsPayment) {
    return XfR.ok(customsPaymentServiceImpl.page(page, Wrappers.query(customsPayment)));
  }

  /**
   * 通过id查询海关缴款书主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/customspayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsPaymentServiceImpl.getById(id));
  }

  /**
   * 新增海关缴款书主信息
   * @param customsPayment 海关缴款书主信息
   * @return XfR
   */
  @PostMapping("/customspayments")
  public XfR save(@RequestBody CustomsPayment customsPayment) {
     return XfR.ok(customsPaymentServiceImpl.save(customsPayment));
  }

  /**
   * 修改-传入修改后的全部数据海关缴款书主信息
   * @param customsPayment 海关缴款书主信息
   * @return XfR
   */
  @PutMapping("/customspayments/{id}")
  public XfR putUpdate(@RequestBody CustomsPayment customsPayment,@PathVariable Long id) {
      customsPayment.setId(id);
      return XfR.ok(customsPaymentServiceImpl.updateById(customsPayment));
  }

  /**
   * 修改-传入修改的数据海关缴款书主信息
   * @param customsPayment 海关缴款书主信息
   * @return XfR
   */
  @PatchMapping("/customspayments/{id}")
  public XfR patchUpdate(@RequestBody CustomsPayment customsPayment,@PathVariable Long id) {
      CustomsPayment upcustomsPayment = customsPaymentServiceImpl.getById(id);
      if(upcustomsPayment != null){
        upcustomsPayment = ObjectCopyUtils.copyProperties(customsPayment,upcustomsPayment,true);
      }
      return XfR.ok(customsPaymentServiceImpl.updateById(upcustomsPayment));
  }

  /**
   * 通过id删除海关缴款书主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customspayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/customspayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_payment");
     params.put("request", condition);

     return XfR.ok(customsPaymentServiceImpl.querys(params));
  }

}
