package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.FunctionConfig;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IFunctionConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 功能点配置对象前端控制器
 *
 * @author ultraman
 * @date 2023-03-07
 */
@RestController
public class FunctionConfigController {

  @Autowired
  private IFunctionConfigService functionConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param functionConfig 功能点配置对象
   * @return
   */
  @GetMapping("/functionconfigs" )
  public XfR getFunctionConfigs(XfPage page, FunctionConfig functionConfig) {
    return XfR.ok(functionConfigServiceImpl.page(page, Wrappers.query(functionConfig)));
  }

  /**
   * 通过id查询功能点配置对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/functionconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(functionConfigServiceImpl.getById(id));
  }

  /**
   * 新增功能点配置对象
   * @param functionConfig 功能点配置对象
   * @return XfR
   */
  @PostMapping("/functionconfigs")
  public XfR save(@RequestBody FunctionConfig functionConfig) {
     return XfR.ok(functionConfigServiceImpl.save(functionConfig));
  }

  /**
   * 修改-传入修改后的全部数据功能点配置对象
   * @param functionConfig 功能点配置对象
   * @return XfR
   */
  @PutMapping("/functionconfigs/{id}")
  public XfR putUpdate(@RequestBody FunctionConfig functionConfig,@PathVariable Long id) {
      functionConfig.setId(id);
      return XfR.ok(functionConfigServiceImpl.updateById(functionConfig));
  }

  /**
   * 修改-传入修改的数据功能点配置对象
   * @param functionConfig 功能点配置对象
   * @return XfR
   */
  @PatchMapping("/functionconfigs/{id}")
  public XfR patchUpdate(@RequestBody FunctionConfig functionConfig,@PathVariable Long id) {
      FunctionConfig upfunctionConfig = functionConfigServiceImpl.getById(id);
      if(upfunctionConfig != null){
        upfunctionConfig = ObjectCopyUtils.copyProperties(functionConfig,upfunctionConfig,true);
      }
      return XfR.ok(functionConfigServiceImpl.updateById(upfunctionConfig));
  }

  /**
   * 通过id删除功能点配置对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/functionconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(functionConfigServiceImpl.removeById(id));
  }

  @PostMapping("/functionconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "function_config");
     params.put("request", condition);

     return XfR.ok(functionConfigServiceImpl.querys(params));
  }

}
