package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.CustomsPaymentCheckTask;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.ICustomsPaymentCheckTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 海关缴款书勾选记录表前端控制器
 *
 * @author ultraman
 * @date 2023-06-07
 */
@RestController
public class CustomsPaymentCheckTaskController {

  @Autowired
  private ICustomsPaymentCheckTaskService customsPaymentCheckTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsPaymentCheckTask 海关缴款书勾选记录表
   * @return
   */
  @GetMapping("/customspaymentchecktasks" )
  public XfR getCustomsPaymentCheckTasks(XfPage page, CustomsPaymentCheckTask customsPaymentCheckTask) {
    return XfR.ok(customsPaymentCheckTaskServiceImpl.page(page, Wrappers.query(customsPaymentCheckTask)));
  }

  /**
   * 通过id查询海关缴款书勾选记录表
   * @param  id
   * @return XfR
   */
  @GetMapping("/customspaymentchecktasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsPaymentCheckTaskServiceImpl.getById(id));
  }

  /**
   * 新增海关缴款书勾选记录表
   * @param customsPaymentCheckTask 海关缴款书勾选记录表
   * @return XfR
   */
  @PostMapping("/customspaymentchecktasks")
  public XfR save(@RequestBody CustomsPaymentCheckTask customsPaymentCheckTask) {
     return XfR.ok(customsPaymentCheckTaskServiceImpl.save(customsPaymentCheckTask));
  }

  /**
   * 修改-传入修改后的全部数据海关缴款书勾选记录表
   * @param customsPaymentCheckTask 海关缴款书勾选记录表
   * @return XfR
   */
  @PutMapping("/customspaymentchecktasks/{id}")
  public XfR putUpdate(@RequestBody CustomsPaymentCheckTask customsPaymentCheckTask,@PathVariable Long id) {
      customsPaymentCheckTask.setId(id);
      return XfR.ok(customsPaymentCheckTaskServiceImpl.updateById(customsPaymentCheckTask));
  }

  /**
   * 修改-传入修改的数据海关缴款书勾选记录表
   * @param customsPaymentCheckTask 海关缴款书勾选记录表
   * @return XfR
   */
  @PatchMapping("/customspaymentchecktasks/{id}")
  public XfR patchUpdate(@RequestBody CustomsPaymentCheckTask customsPaymentCheckTask,@PathVariable Long id) {
      CustomsPaymentCheckTask upcustomsPaymentCheckTask = customsPaymentCheckTaskServiceImpl.getById(id);
      if(upcustomsPaymentCheckTask != null){
        upcustomsPaymentCheckTask = ObjectCopyUtils.copyProperties(customsPaymentCheckTask,upcustomsPaymentCheckTask,true);
      }
      return XfR.ok(customsPaymentCheckTaskServiceImpl.updateById(upcustomsPaymentCheckTask));
  }

  /**
   * 通过id删除海关缴款书勾选记录表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customspaymentchecktasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsPaymentCheckTaskServiceImpl.removeById(id));
  }

  @PostMapping("/customspaymentchecktasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_payment_check_task");
     params.put("request", condition);

     return XfR.ok(customsPaymentCheckTaskServiceImpl.querys(params));
  }

}
