package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceMain;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IInvoiceMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票票面信息前端控制器
 *
 * @author ultraman
 * @date 2023-07-05
 */
@RestController
public class InvoiceMainController {

  @Autowired
  private IInvoiceMainService invoiceMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMain 发票票面信息
   * @return
   */
  @GetMapping("/invoicemains" )
  public XfR getInvoiceMains(XfPage page, InvoiceMain invoiceMain) {
    return XfR.ok(invoiceMainServiceImpl.page(page, Wrappers.query(invoiceMain)));
  }

  /**
   * 通过id查询发票票面信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMainServiceImpl.getById(id));
  }

  /**
   * 新增发票票面信息
   * @param invoiceMain 发票票面信息
   * @return XfR
   */
  @PostMapping("/invoicemains")
  public XfR save(@RequestBody InvoiceMain invoiceMain) {
     return XfR.ok(invoiceMainServiceImpl.save(invoiceMain));
  }

  /**
   * 修改-传入修改后的全部数据发票票面信息
   * @param invoiceMain 发票票面信息
   * @return XfR
   */
  @PutMapping("/invoicemains/{id}")
  public XfR putUpdate(@RequestBody InvoiceMain invoiceMain,@PathVariable Long id) {
      invoiceMain.setId(id);
      return XfR.ok(invoiceMainServiceImpl.updateById(invoiceMain));
  }

  /**
   * 修改-传入修改的数据发票票面信息
   * @param invoiceMain 发票票面信息
   * @return XfR
   */
  @PatchMapping("/invoicemains/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMain invoiceMain,@PathVariable Long id) {
      InvoiceMain upinvoiceMain = invoiceMainServiceImpl.getById(id);
      if(upinvoiceMain != null){
        upinvoiceMain = ObjectCopyUtils.copyProperties(invoiceMain,upinvoiceMain,true);
      }
      return XfR.ok(invoiceMainServiceImpl.updateById(upinvoiceMain));
  }

  /**
   * 通过id删除发票票面信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMainServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_main");
     params.put("request", condition);

     return XfR.ok(invoiceMainServiceImpl.querys(params));
  }

}
