package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.Company;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.ICompanyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-15
 */
@RestController
public class CompanyController {

  @Autowired
  private ICompanyService companyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param company ${table.comment}
   * @return
   */
  @GetMapping("/companys" )
  public XfR getCompanys(XfPage page, Company company) {
    return XfR.ok(companyServiceImpl.page(page, Wrappers.query(company)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/companys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(companyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param company ${table.comment}
   * @return XfR
   */
  @PostMapping("/companys")
  public XfR save(@RequestBody Company company) {
     return XfR.ok(companyServiceImpl.save(company));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param company ${table.comment}
   * @return XfR
   */
  @PutMapping("/companys/{id}")
  public XfR putUpdate(@RequestBody Company company,@PathVariable Long id) {
      company.setId(id);
      return XfR.ok(companyServiceImpl.updateById(company));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param company ${table.comment}
   * @return XfR
   */
  @PatchMapping("/companys/{id}")
  public XfR patchUpdate(@RequestBody Company company,@PathVariable Long id) {
      Company upcompany = companyServiceImpl.getById(id);
      if(upcompany != null){
        upcompany = ObjectCopyUtils.copyProperties(company,upcompany,true);
      }
      return XfR.ok(companyServiceImpl.updateById(upcompany));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/companys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(companyServiceImpl.removeById(id));
  }

  @PostMapping("/companys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "company");
     params.put("request", condition);

     return XfR.ok(companyServiceImpl.querys(params));
  }

}
