package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoicePushLog;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IInvoicePushLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票推送下游履历前端控制器
 *
 * @author ultraman
 * @date 2023-08-15
 */
@RestController
public class InvoicePushLogController {

  @Autowired
  private IInvoicePushLogService invoicePushLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePushLog 发票推送下游履历
   * @return
   */
  @GetMapping("/invoicepushlogs" )
  public XfR getInvoicePushLogs(XfPage page, InvoicePushLog invoicePushLog) {
    return XfR.ok(invoicePushLogServiceImpl.page(page, Wrappers.query(invoicePushLog)));
  }

  /**
   * 通过id查询发票推送下游履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicepushlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePushLogServiceImpl.getById(id));
  }

  /**
   * 新增发票推送下游履历
   * @param invoicePushLog 发票推送下游履历
   * @return XfR
   */
  @PostMapping("/invoicepushlogs")
  public XfR save(@RequestBody InvoicePushLog invoicePushLog) {
     return XfR.ok(invoicePushLogServiceImpl.save(invoicePushLog));
  }

  /**
   * 修改-传入修改后的全部数据发票推送下游履历
   * @param invoicePushLog 发票推送下游履历
   * @return XfR
   */
  @PutMapping("/invoicepushlogs/{id}")
  public XfR putUpdate(@RequestBody InvoicePushLog invoicePushLog,@PathVariable Long id) {
      invoicePushLog.setId(id);
      return XfR.ok(invoicePushLogServiceImpl.updateById(invoicePushLog));
  }

  /**
   * 修改-传入修改的数据发票推送下游履历
   * @param invoicePushLog 发票推送下游履历
   * @return XfR
   */
  @PatchMapping("/invoicepushlogs/{id}")
  public XfR patchUpdate(@RequestBody InvoicePushLog invoicePushLog,@PathVariable Long id) {
      InvoicePushLog upinvoicePushLog = invoicePushLogServiceImpl.getById(id);
      if(upinvoicePushLog != null){
        upinvoicePushLog = ObjectCopyUtils.copyProperties(invoicePushLog,upinvoicePushLog,true);
      }
      return XfR.ok(invoicePushLogServiceImpl.updateById(upinvoicePushLog));
  }

  /**
   * 通过id删除发票推送下游履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicepushlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePushLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoicepushlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_push_log");
     params.put("request", condition);

     return XfR.ok(invoicePushLogServiceImpl.querys(params));
  }

}
