package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.InvoiceReceiveLog;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IInvoiceReceiveLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 发票接收履历对象前端控制器
 *
 * @author ultraman
 * @date 2023-08-15
 */
@RestController
public class InvoiceReceiveLogController {

  @Autowired
  private IInvoiceReceiveLogService invoiceReceiveLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceReceiveLog 发票接收履历对象
   * @return
   */
  @GetMapping("/invoicereceivelogs" )
  public XfR getInvoiceReceiveLogs(XfPage page, InvoiceReceiveLog invoiceReceiveLog) {
    return XfR.ok(invoiceReceiveLogServiceImpl.page(page, Wrappers.query(invoiceReceiveLog)));
  }

  /**
   * 通过id查询发票接收履历对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicereceivelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiveLogServiceImpl.getById(id));
  }

  /**
   * 新增发票接收履历对象
   * @param invoiceReceiveLog 发票接收履历对象
   * @return XfR
   */
  @PostMapping("/invoicereceivelogs")
  public XfR save(@RequestBody InvoiceReceiveLog invoiceReceiveLog) {
     return XfR.ok(invoiceReceiveLogServiceImpl.save(invoiceReceiveLog));
  }

  /**
   * 修改-传入修改后的全部数据发票接收履历对象
   * @param invoiceReceiveLog 发票接收履历对象
   * @return XfR
   */
  @PutMapping("/invoicereceivelogs/{id}")
  public XfR putUpdate(@RequestBody InvoiceReceiveLog invoiceReceiveLog,@PathVariable Long id) {
      invoiceReceiveLog.setId(id);
      return XfR.ok(invoiceReceiveLogServiceImpl.updateById(invoiceReceiveLog));
  }

  /**
   * 修改-传入修改的数据发票接收履历对象
   * @param invoiceReceiveLog 发票接收履历对象
   * @return XfR
   */
  @PatchMapping("/invoicereceivelogs/{id}")
  public XfR patchUpdate(@RequestBody InvoiceReceiveLog invoiceReceiveLog,@PathVariable Long id) {
      InvoiceReceiveLog upinvoiceReceiveLog = invoiceReceiveLogServiceImpl.getById(id);
      if(upinvoiceReceiveLog != null){
        upinvoiceReceiveLog = ObjectCopyUtils.copyProperties(invoiceReceiveLog,upinvoiceReceiveLog,true);
      }
      return XfR.ok(invoiceReceiveLogServiceImpl.updateById(upinvoiceReceiveLog));
  }

  /**
   * 通过id删除发票接收履历对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicereceivelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceReceiveLogServiceImpl.removeById(id));
  }

  @PostMapping("/invoicereceivelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_receive_log");
     params.put("request", condition);

     return XfR.ok(invoiceReceiveLogServiceImpl.querys(params));
  }

}
