package com.xforceplus.ultraman.app.purchaserinvoicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.entity.WithholdingVoucherCheckTask;
import com.xforceplus.ultraman.app.purchaserinvoicesaas.service.IWithholdingVoucherCheckTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 代扣代缴凭证勾选任务前端控制器
 *
 * @author ultraman
 * @date 2023-10-10
 */
@RestController
public class WithholdingVoucherCheckTaskController {

  @Autowired
  private IWithholdingVoucherCheckTaskService withholdingVoucherCheckTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return
   */
  @GetMapping("/withholdingvoucherchecktasks" )
  public XfR getWithholdingVoucherCheckTasks(XfPage page, WithholdingVoucherCheckTask withholdingVoucherCheckTask) {
    return XfR.ok(withholdingVoucherCheckTaskServiceImpl.page(page, Wrappers.query(withholdingVoucherCheckTask)));
  }

  /**
   * 通过id查询代扣代缴凭证勾选任务
   * @param  id
   * @return XfR
   */
  @GetMapping("/withholdingvoucherchecktasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(withholdingVoucherCheckTaskServiceImpl.getById(id));
  }

  /**
   * 新增代扣代缴凭证勾选任务
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return XfR
   */
  @PostMapping("/withholdingvoucherchecktasks")
  public XfR save(@RequestBody WithholdingVoucherCheckTask withholdingVoucherCheckTask) {
     return XfR.ok(withholdingVoucherCheckTaskServiceImpl.save(withholdingVoucherCheckTask));
  }

  /**
   * 修改-传入修改后的全部数据代扣代缴凭证勾选任务
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return XfR
   */
  @PutMapping("/withholdingvoucherchecktasks/{id}")
  public XfR putUpdate(@RequestBody WithholdingVoucherCheckTask withholdingVoucherCheckTask,@PathVariable Long id) {
      withholdingVoucherCheckTask.setId(id);
      return XfR.ok(withholdingVoucherCheckTaskServiceImpl.updateById(withholdingVoucherCheckTask));
  }

  /**
   * 修改-传入修改的数据代扣代缴凭证勾选任务
   * @param withholdingVoucherCheckTask 代扣代缴凭证勾选任务
   * @return XfR
   */
  @PatchMapping("/withholdingvoucherchecktasks/{id}")
  public XfR patchUpdate(@RequestBody WithholdingVoucherCheckTask withholdingVoucherCheckTask,@PathVariable Long id) {
      WithholdingVoucherCheckTask upwithholdingVoucherCheckTask = withholdingVoucherCheckTaskServiceImpl.getById(id);
      if(upwithholdingVoucherCheckTask != null){
        upwithholdingVoucherCheckTask = ObjectCopyUtils.copyProperties(withholdingVoucherCheckTask,upwithholdingVoucherCheckTask,true);
      }
      return XfR.ok(withholdingVoucherCheckTaskServiceImpl.updateById(upwithholdingVoucherCheckTask));
  }

  /**
   * 通过id删除代扣代缴凭证勾选任务
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/withholdingvoucherchecktasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(withholdingVoucherCheckTaskServiceImpl.removeById(id));
  }

  @PostMapping("/withholdingvoucherchecktasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "withholding_voucher_check_task");
     params.put("request", condition);

     return XfR.ok(withholdingVoucherCheckTaskServiceImpl.querys(params));
  }

}
