package com.xforceplus.ultraman.app.saasnotifierservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-11-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class IssuedFailedAlarmRule implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   *  销方租户代码
   */
  @TableField("sellerTenantCode")
  private String sellerTenantCode;

  /**
   * 销方组织代码
   */
  @TableField("sellerOrgCode")
  private String sellerOrgCode;

  /**
   *  销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 报警类型
   */
  @TableField("alarmType")
  private String alarmType;

  /**
   * 状态
   */
  private String status;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织 ID
   */
  @TableField("sysOrgId")
  private String sysOrgId;

  /**
   * 通知时间
   */
  @TableField("alarmTime")
  private String alarmTime;

  /**
   * 租户名称
   */
  @TableField("tenantName")
  private String tenantName;

  /**
   *  通知方式
   */
  @TableField("notifyType")
  private String notifyType;

  /**
   *  消息通知模板
   */
  @TableField("notifyTemplate")
  private String notifyTemplate;

  /**
   * 通知人
   */
  @TableField("notifyRecipient")
  private String notifyRecipient;

  /**
   *  组织名称
   */
  @TableField("sysOrgName")
  private String sysOrgName;

  /**
   *  组织类型
   */
  @TableField("orgType")
  private String orgType;


  /**
   * 对一关联关系 关联对象 org
   */
    private Long ruleOrgId;
  /**
   * 对一关联关系 关联对象 company
   */
    private Long ruleCompanyId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sellerTenantCode", sellerTenantCode);
      map.put("sellerOrgCode", sellerOrgCode);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("alarmType", alarmType);
      map.put("status", status);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sysOrgId", sysOrgId);
      map.put("alarmTime", alarmTime);
      map.put("tenantName", tenantName);
      map.put("notifyType", notifyType);
      map.put("notifyTemplate", notifyTemplate);
      map.put("notifyRecipient", notifyRecipient);
      map.put("sysOrgName", sysOrgName);
      map.put("orgType", orgType);

       map.put("ruleOrg.id", ruleOrgId);
       map.put("ruleCompany.id", ruleCompanyId);
      return map;
  }

  public static IssuedFailedAlarmRule fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    IssuedFailedAlarmRule entity = new IssuedFailedAlarmRule();
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerOrgCode")) {
      Object obj = map.get("sellerOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alarmType")) {
      Object obj = map.get("alarmType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlarmType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alarmTime")) {
      Object obj = map.get("alarmTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAlarmTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notifyType")) {
      Object obj = map.get("notifyType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotifyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notifyTemplate")) {
      Object obj = map.get("notifyTemplate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotifyTemplate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notifyRecipient")) {
      Object obj = map.get("notifyRecipient");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotifyRecipient((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sysOrgName")) {
      Object obj = map.get("sysOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orgType")) {
      Object obj = map.get("orgType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("ruleOrg.id")) {
        Object obj = map.get("ruleOrg.id");
      if(obj instanceof Long) {
        entity.setRuleOrgId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setRuleOrgId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("ruleCompany.id")) {
        Object obj = map.get("ruleCompany.id");
      if(obj instanceof Long) {
        entity.setRuleCompanyId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setRuleCompanyId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sellerTenantCode")) {
      Object obj = map.get("sellerTenantCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerOrgCode")) {
      Object obj = map.get("sellerOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alarmType")) {
      Object obj = map.get("alarmType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlarmType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sysOrgId")) {
      Object obj = map.get("sysOrgId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysOrgId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alarmTime")) {
      Object obj = map.get("alarmTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAlarmTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenantName")) {
      Object obj = map.get("tenantName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notifyType")) {
      Object obj = map.get("notifyType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotifyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notifyTemplate")) {
      Object obj = map.get("notifyTemplate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotifyTemplate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notifyRecipient")) {
      Object obj = map.get("notifyRecipient");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotifyRecipient((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sysOrgName")) {
      Object obj = map.get("sysOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orgType")) {
      Object obj = map.get("orgType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("ruleOrg.id")) {
        Object obj = map.get("ruleOrg.id");
        if(obj instanceof Long) {
          this.setRuleOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRuleOrgId(Long.parseLong((String)obj));
        }
      }
      if(map.containsKey("ruleCompany.id")) {
        Object obj = map.get("ruleCompany.id");
        if(obj instanceof Long) {
          this.setRuleCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRuleCompanyId(Long.parseLong((String)obj));
        }
      }
  }
}
