package com.xforceplus.ultraman.app.saasnotifierservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * issue_failed_alarm_strategy
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum IssueFailedAlarmStrategy {

    _1("1", "整点选择报警策略");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IssueFailedAlarmStrategy(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IssueFailedAlarmStrategy fromCode(String code) {
        return Stream.of(IssueFailedAlarmStrategy.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
