package com.xforceplus.ultraman.app.saasnotifierservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * issue_failed_recovery_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public enum IssueFailedRecoveryStatus {

    _0("0", "失败中"),
    _1("1", "已恢复");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IssueFailedRecoveryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IssueFailedRecoveryStatus fromCode(String code) {
        return Stream.of(IssueFailedRecoveryStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
