package com.xforceplus.ultraman.app.saasnotifierservice.metadata.validator;

import com.xforceplus.ultraman.app.saasnotifierservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.saasnotifierservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-11-23
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFailedRecoveryStatus.class)) {
            isValid = null != IssueFailedRecoveryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IssueFailedRecoveryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFailedAlarmStrategy.class)) {
            isValid = null != IssueFailedAlarmStrategy.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IssueFailedAlarmStrategy.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleStatus.class)) {
            isValid = null != RuleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
