package com.xforceplus.ultraman.app.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.saasnotifierservice.entity.IssueFailedRecord;
import com.xforceplus.ultraman.app.saasnotifierservice.service.IIssueFailedRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-15
 */
@RestController
public class IssueFailedRecordController {

  @Autowired
  private IIssueFailedRecordService issueFailedRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param issueFailedRecord ${table.comment}
   * @return
   */
  @GetMapping("/issuefailedrecords" )
  public XfR getIssueFailedRecords(XfPage page, IssueFailedRecord issueFailedRecord) {
    return XfR.ok(issueFailedRecordServiceImpl.page(page, Wrappers.query(issueFailedRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/issuefailedrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(issueFailedRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param issueFailedRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/issuefailedrecords")
  public XfR save(@RequestBody IssueFailedRecord issueFailedRecord) {
     return XfR.ok(issueFailedRecordServiceImpl.save(issueFailedRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param issueFailedRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/issuefailedrecords/{id}")
  public XfR putUpdate(@RequestBody IssueFailedRecord issueFailedRecord,@PathVariable Long id) {
      issueFailedRecord.setId(id);
      return XfR.ok(issueFailedRecordServiceImpl.updateById(issueFailedRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param issueFailedRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/issuefailedrecords/{id}")
  public XfR patchUpdate(@RequestBody IssueFailedRecord issueFailedRecord,@PathVariable Long id) {
      IssueFailedRecord upissueFailedRecord = issueFailedRecordServiceImpl.getById(id);
      if(upissueFailedRecord != null){
        upissueFailedRecord = ObjectCopyUtils.copyProperties(issueFailedRecord,upissueFailedRecord,true);
      }
      return XfR.ok(issueFailedRecordServiceImpl.updateById(upissueFailedRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/issuefailedrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(issueFailedRecordServiceImpl.removeById(id));
  }

  @PostMapping("/issuefailedrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "issue_failed_record");
     params.put("request", condition);

     return XfR.ok(issueFailedRecordServiceImpl.querys(params));
  }

}
