package com.xforceplus.ultraman.app.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.saasnotifierservice.entity.IssuedFailedAlarmRule;
import com.xforceplus.ultraman.app.saasnotifierservice.service.IIssuedFailedAlarmRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-15
 */
@RestController
public class IssuedFailedAlarmRuleController {

  @Autowired
  private IIssuedFailedAlarmRuleService issuedFailedAlarmRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param issuedFailedAlarmRule ${table.comment}
   * @return
   */
  @GetMapping("/issuedfailedalarmrules" )
  public XfR getIssuedFailedAlarmRules(XfPage page, IssuedFailedAlarmRule issuedFailedAlarmRule) {
    return XfR.ok(issuedFailedAlarmRuleServiceImpl.page(page, Wrappers.query(issuedFailedAlarmRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/issuedfailedalarmrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(issuedFailedAlarmRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param issuedFailedAlarmRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/issuedfailedalarmrules")
  public XfR save(@RequestBody IssuedFailedAlarmRule issuedFailedAlarmRule) {
     return XfR.ok(issuedFailedAlarmRuleServiceImpl.save(issuedFailedAlarmRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param issuedFailedAlarmRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/issuedfailedalarmrules/{id}")
  public XfR putUpdate(@RequestBody IssuedFailedAlarmRule issuedFailedAlarmRule,@PathVariable Long id) {
      issuedFailedAlarmRule.setId(id);
      return XfR.ok(issuedFailedAlarmRuleServiceImpl.updateById(issuedFailedAlarmRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param issuedFailedAlarmRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/issuedfailedalarmrules/{id}")
  public XfR patchUpdate(@RequestBody IssuedFailedAlarmRule issuedFailedAlarmRule,@PathVariable Long id) {
      IssuedFailedAlarmRule upissuedFailedAlarmRule = issuedFailedAlarmRuleServiceImpl.getById(id);
      if(upissuedFailedAlarmRule != null){
        upissuedFailedAlarmRule = ObjectCopyUtils.copyProperties(issuedFailedAlarmRule,upissuedFailedAlarmRule,true);
      }
      return XfR.ok(issuedFailedAlarmRuleServiceImpl.updateById(upissuedFailedAlarmRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/issuedfailedalarmrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(issuedFailedAlarmRuleServiceImpl.removeById(id));
  }

  @PostMapping("/issuedfailedalarmrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "issued_failed_alarm_rule");
     params.put("request", condition);

     return XfR.ok(issuedFailedAlarmRuleServiceImpl.querys(params));
  }

}
