package com.xforceplus.ultraman.app.saasnotifierservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.saasnotifierservice.entity.MissingInvoiceWarningRule;
import com.xforceplus.ultraman.app.saasnotifierservice.service.IMissingInvoiceWarningRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-15
 */
@RestController
public class MissingInvoiceWarningRuleController {

  @Autowired
  private IMissingInvoiceWarningRuleService missingInvoiceWarningRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param missingInvoiceWarningRule ${table.comment}
   * @return
   */
  @GetMapping("/missinginvoicewarningrules" )
  public XfR getMissingInvoiceWarningRules(XfPage page, MissingInvoiceWarningRule missingInvoiceWarningRule) {
    return XfR.ok(missingInvoiceWarningRuleServiceImpl.page(page, Wrappers.query(missingInvoiceWarningRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/missinginvoicewarningrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(missingInvoiceWarningRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param missingInvoiceWarningRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/missinginvoicewarningrules")
  public XfR save(@RequestBody MissingInvoiceWarningRule missingInvoiceWarningRule) {
     return XfR.ok(missingInvoiceWarningRuleServiceImpl.save(missingInvoiceWarningRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param missingInvoiceWarningRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/missinginvoicewarningrules/{id}")
  public XfR putUpdate(@RequestBody MissingInvoiceWarningRule missingInvoiceWarningRule,@PathVariable Long id) {
      missingInvoiceWarningRule.setId(id);
      return XfR.ok(missingInvoiceWarningRuleServiceImpl.updateById(missingInvoiceWarningRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param missingInvoiceWarningRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/missinginvoicewarningrules/{id}")
  public XfR patchUpdate(@RequestBody MissingInvoiceWarningRule missingInvoiceWarningRule,@PathVariable Long id) {
      MissingInvoiceWarningRule upmissingInvoiceWarningRule = missingInvoiceWarningRuleServiceImpl.getById(id);
      if(upmissingInvoiceWarningRule != null){
        upmissingInvoiceWarningRule = ObjectCopyUtils.copyProperties(missingInvoiceWarningRule,upmissingInvoiceWarningRule,true);
      }
      return XfR.ok(missingInvoiceWarningRuleServiceImpl.updateById(upmissingInvoiceWarningRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/missinginvoicewarningrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(missingInvoiceWarningRuleServiceImpl.removeById(id));
  }

  @PostMapping("/missinginvoicewarningrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "missing_invoice_warning_rule");
     params.put("request", condition);

     return XfR.ok(missingInvoiceWarningRuleServiceImpl.querys(params));
  }

}
