package com.xforceplus.ultraman.app.sdktest.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OqsBo292934 implements Serializable {

  private static final long serialVersionUID=1L;

  private Long d1;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime d2;

  private BigDecimal d3;

  private String d4;

  private String d5;

  private String d6;

  private String d7;

  private Long d8;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("d1", d1);
      map.put("d2", BocpGenUtils.toTimestamp(d2));
      map.put("d3", d3);
      map.put("d4", d4);
      map.put("d5", d5);
      map.put("d6", d6);
      map.put("d7", d7);
      map.put("d8", d8);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static OqsBo292934 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OqsBo292934 entity = new OqsBo292934();
    if(map.containsKey("d1")) {
      Object obj = map.get("d1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setD1((Long)obj);
        } else if(obj instanceof String) {
          entity.setD1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setD1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("d2")) {
      Object obj = map.get("d2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setD2(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setD2((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setD2(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setD2(null);
      }
    }
    if(map.containsKey("d3")) {
      Object obj = map.get("d3");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setD3((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setD3(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setD3(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setD3(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setD3(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("d4")) {
      Object obj = map.get("d4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setD4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d5")) {
      Object obj = map.get("d5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d6")) {
      Object obj = map.get("d6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setD6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d7")) {
      Object obj = map.get("d7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setD7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("d8")) {
      Object obj = map.get("d8");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setD8((Long)obj);
        } else if(obj instanceof String) {
          entity.setD8(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setD8(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
