package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.APerson;
import com.xforceplus.ultraman.app.sdktest.service.IAPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class APersonController {

  @Autowired
  private IAPersonService APersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aPerson ${table.comment}
   * @return
   */
  @GetMapping("/apersons" )
  public XfR getAPersons(XfPage page, APerson aPerson) {
    return XfR.ok(APersonServiceImpl.page(page, Wrappers.query(aPerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(APersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aPerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/apersons")
  public XfR save(@RequestBody APerson aPerson) {
     return XfR.ok(APersonServiceImpl.save(aPerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aPerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/apersons/{id}")
  public XfR putUpdate(@RequestBody APerson aPerson,@PathVariable Long id) {
      aPerson.setId(id);
      return XfR.ok(APersonServiceImpl.updateById(aPerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aPerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apersons/{id}")
  public XfR patchUpdate(@RequestBody APerson aPerson,@PathVariable Long id) {
      APerson upaPerson = APersonServiceImpl.getById(id);
      if(upaPerson != null){
        upaPerson = ObjectCopyUtils.copyProperties(aPerson,upaPerson,true);
      }
      return XfR.ok(APersonServiceImpl.updateById(upaPerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(APersonServiceImpl.removeById(id));
  }

  @PostMapping("/apersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a_person");
     params.put("request", condition);

     return XfR.ok(APersonServiceImpl.querys(params));
  }

}
