package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Aaaa;
import com.xforceplus.ultraman.app.sdktest.service.IAaaaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AaaaController {

  @Autowired
  private IAaaaService aaaaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param aaaa ${table.comment}
   * @return
   */
  @GetMapping("/aaaas" )
  public XfR getAaaas(XfPage page, Aaaa aaaa) {
    return XfR.ok(aaaaServiceImpl.page(page, Wrappers.query(aaaa)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/aaaas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(aaaaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param aaaa ${table.comment}
   * @return XfR
   */
  @PostMapping("/aaaas")
  public XfR save(@RequestBody Aaaa aaaa) {
     return XfR.ok(aaaaServiceImpl.save(aaaa));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param aaaa ${table.comment}
   * @return XfR
   */
  @PutMapping("/aaaas/{id}")
  public XfR putUpdate(@RequestBody Aaaa aaaa,@PathVariable Long id) {
      aaaa.setId(id);
      return XfR.ok(aaaaServiceImpl.updateById(aaaa));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param aaaa ${table.comment}
   * @return XfR
   */
  @PatchMapping("/aaaas/{id}")
  public XfR patchUpdate(@RequestBody Aaaa aaaa,@PathVariable Long id) {
      Aaaa upaaaa = aaaaServiceImpl.getById(id);
      if(upaaaa != null){
        upaaaa = ObjectCopyUtils.copyProperties(aaaa,upaaaa,true);
      }
      return XfR.ok(aaaaServiceImpl.updateById(upaaaa));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/aaaas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(aaaaServiceImpl.removeById(id));
  }

  @PostMapping("/aaaas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "aaaa");
     params.put("request", condition);

     return XfR.ok(aaaaServiceImpl.querys(params));
  }

}
