package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ActionTrail;
import com.xforceplus.ultraman.app.sdktest.service.IActionTrailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ActionTrailController {

  @Autowired
  private IActionTrailService actionTrailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param actionTrail ${table.comment}
   * @return
   */
  @GetMapping("/actiontrails" )
  public XfR getActionTrails(XfPage page, ActionTrail actionTrail) {
    return XfR.ok(actionTrailServiceImpl.page(page, Wrappers.query(actionTrail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/actiontrails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(actionTrailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param actionTrail ${table.comment}
   * @return XfR
   */
  @PostMapping("/actiontrails")
  public XfR save(@RequestBody ActionTrail actionTrail) {
     return XfR.ok(actionTrailServiceImpl.save(actionTrail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param actionTrail ${table.comment}
   * @return XfR
   */
  @PutMapping("/actiontrails/{id}")
  public XfR putUpdate(@RequestBody ActionTrail actionTrail,@PathVariable Long id) {
      actionTrail.setId(id);
      return XfR.ok(actionTrailServiceImpl.updateById(actionTrail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param actionTrail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/actiontrails/{id}")
  public XfR patchUpdate(@RequestBody ActionTrail actionTrail,@PathVariable Long id) {
      ActionTrail upactionTrail = actionTrailServiceImpl.getById(id);
      if(upactionTrail != null){
        upactionTrail = ObjectCopyUtils.copyProperties(actionTrail,upactionTrail,true);
      }
      return XfR.ok(actionTrailServiceImpl.updateById(upactionTrail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/actiontrails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(actionTrailServiceImpl.removeById(id));
  }

  @PostMapping("/actiontrails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "action_trail");
     params.put("request", condition);

     return XfR.ok(actionTrailServiceImpl.querys(params));
  }

}
