package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Air;
import com.xforceplus.ultraman.app.sdktest.service.IAirService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AirController {

  @Autowired
  private IAirService airServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param air ${table.comment}
   * @return
   */
  @GetMapping("/airs" )
  public XfR getAirs(XfPage page, Air air) {
    return XfR.ok(airServiceImpl.page(page, Wrappers.query(air)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/airs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(airServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param air ${table.comment}
   * @return XfR
   */
  @PostMapping("/airs")
  public XfR save(@RequestBody Air air) {
     return XfR.ok(airServiceImpl.save(air));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param air ${table.comment}
   * @return XfR
   */
  @PutMapping("/airs/{id}")
  public XfR putUpdate(@RequestBody Air air,@PathVariable Long id) {
      air.setId(id);
      return XfR.ok(airServiceImpl.updateById(air));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param air ${table.comment}
   * @return XfR
   */
  @PatchMapping("/airs/{id}")
  public XfR patchUpdate(@RequestBody Air air,@PathVariable Long id) {
      Air upair = airServiceImpl.getById(id);
      if(upair != null){
        upair = ObjectCopyUtils.copyProperties(air,upair,true);
      }
      return XfR.ok(airServiceImpl.updateById(upair));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/airs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(airServiceImpl.removeById(id));
  }

  @PostMapping("/airs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "air");
     params.put("request", condition);

     return XfR.ok(airServiceImpl.querys(params));
  }

}
