package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Airdetail;
import com.xforceplus.ultraman.app.sdktest.service.IAirdetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AirdetailController {

  @Autowired
  private IAirdetailService airdetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param airdetail ${table.comment}
   * @return
   */
  @GetMapping("/airdetails" )
  public XfR getAirdetails(XfPage page, Airdetail airdetail) {
    return XfR.ok(airdetailServiceImpl.page(page, Wrappers.query(airdetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/airdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(airdetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param airdetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/airdetails")
  public XfR save(@RequestBody Airdetail airdetail) {
     return XfR.ok(airdetailServiceImpl.save(airdetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param airdetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/airdetails/{id}")
  public XfR putUpdate(@RequestBody Airdetail airdetail,@PathVariable Long id) {
      airdetail.setId(id);
      return XfR.ok(airdetailServiceImpl.updateById(airdetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param airdetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/airdetails/{id}")
  public XfR patchUpdate(@RequestBody Airdetail airdetail,@PathVariable Long id) {
      Airdetail upairdetail = airdetailServiceImpl.getById(id);
      if(upairdetail != null){
        upairdetail = ObjectCopyUtils.copyProperties(airdetail,upairdetail,true);
      }
      return XfR.ok(airdetailServiceImpl.updateById(upairdetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/airdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(airdetailServiceImpl.removeById(id));
  }

  @PostMapping("/airdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "airdetail");
     params.put("request", condition);

     return XfR.ok(airdetailServiceImpl.querys(params));
  }

}
