package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Akdk;
import com.xforceplus.ultraman.app.sdktest.service.IAkdkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AkdkController {

  @Autowired
  private IAkdkService akdkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param akdk ${table.comment}
   * @return
   */
  @GetMapping("/akdks" )
  public XfR getAkdks(XfPage page, Akdk akdk) {
    return XfR.ok(akdkServiceImpl.page(page, Wrappers.query(akdk)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/akdks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(akdkServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param akdk ${table.comment}
   * @return XfR
   */
  @PostMapping("/akdks")
  public XfR save(@RequestBody Akdk akdk) {
     return XfR.ok(akdkServiceImpl.save(akdk));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param akdk ${table.comment}
   * @return XfR
   */
  @PutMapping("/akdks/{id}")
  public XfR putUpdate(@RequestBody Akdk akdk,@PathVariable Long id) {
      akdk.setId(id);
      return XfR.ok(akdkServiceImpl.updateById(akdk));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param akdk ${table.comment}
   * @return XfR
   */
  @PatchMapping("/akdks/{id}")
  public XfR patchUpdate(@RequestBody Akdk akdk,@PathVariable Long id) {
      Akdk upakdk = akdkServiceImpl.getById(id);
      if(upakdk != null){
        upakdk = ObjectCopyUtils.copyProperties(akdk,upakdk,true);
      }
      return XfR.ok(akdkServiceImpl.updateById(upakdk));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/akdks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(akdkServiceImpl.removeById(id));
  }

  @PostMapping("/akdks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "akdk");
     params.put("request", condition);

     return XfR.ok(akdkServiceImpl.querys(params));
  }

}
