package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.AnotherChild;
import com.xforceplus.ultraman.app.sdktest.service.IAnotherChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AnotherChildController {

  @Autowired
  private IAnotherChildService anotherChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param anotherChild ${table.comment}
   * @return
   */
  @GetMapping("/anotherchilds" )
  public XfR getAnotherChilds(XfPage page, AnotherChild anotherChild) {
    return XfR.ok(anotherChildServiceImpl.page(page, Wrappers.query(anotherChild)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/anotherchilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(anotherChildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param anotherChild ${table.comment}
   * @return XfR
   */
  @PostMapping("/anotherchilds")
  public XfR save(@RequestBody AnotherChild anotherChild) {
     return XfR.ok(anotherChildServiceImpl.save(anotherChild));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param anotherChild ${table.comment}
   * @return XfR
   */
  @PutMapping("/anotherchilds/{id}")
  public XfR putUpdate(@RequestBody AnotherChild anotherChild,@PathVariable Long id) {
      anotherChild.setId(id);
      return XfR.ok(anotherChildServiceImpl.updateById(anotherChild));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param anotherChild ${table.comment}
   * @return XfR
   */
  @PatchMapping("/anotherchilds/{id}")
  public XfR patchUpdate(@RequestBody AnotherChild anotherChild,@PathVariable Long id) {
      AnotherChild upanotherChild = anotherChildServiceImpl.getById(id);
      if(upanotherChild != null){
        upanotherChild = ObjectCopyUtils.copyProperties(anotherChild,upanotherChild,true);
      }
      return XfR.ok(anotherChildServiceImpl.updateById(upanotherChild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/anotherchilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(anotherChildServiceImpl.removeById(id));
  }

  @PostMapping("/anotherchilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "another_child");
     params.put("request", condition);

     return XfR.ok(anotherChildServiceImpl.querys(params));
  }

}
