package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.AppLevel1;
import com.xforceplus.ultraman.app.sdktest.service.IAppLevel1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AppLevel1Controller {

  @Autowired
  private IAppLevel1Service appLevel1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appLevel1 ${table.comment}
   * @return
   */
  @GetMapping("/applevel1s" )
  public XfR getAppLevel1s(XfPage page, AppLevel1 appLevel1) {
    return XfR.ok(appLevel1ServiceImpl.page(page, Wrappers.query(appLevel1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/applevel1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appLevel1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param appLevel1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/applevel1s")
  public XfR save(@RequestBody AppLevel1 appLevel1) {
     return XfR.ok(appLevel1ServiceImpl.save(appLevel1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param appLevel1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/applevel1s/{id}")
  public XfR putUpdate(@RequestBody AppLevel1 appLevel1,@PathVariable Long id) {
      appLevel1.setId(id);
      return XfR.ok(appLevel1ServiceImpl.updateById(appLevel1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param appLevel1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/applevel1s/{id}")
  public XfR patchUpdate(@RequestBody AppLevel1 appLevel1,@PathVariable Long id) {
      AppLevel1 upappLevel1 = appLevel1ServiceImpl.getById(id);
      if(upappLevel1 != null){
        upappLevel1 = ObjectCopyUtils.copyProperties(appLevel1,upappLevel1,true);
      }
      return XfR.ok(appLevel1ServiceImpl.updateById(upappLevel1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applevel1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appLevel1ServiceImpl.removeById(id));
  }

  @PostMapping("/applevel1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_level1");
     params.put("request", condition);

     return XfR.ok(appLevel1ServiceImpl.querys(params));
  }

}
