package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.AppLevel2;
import com.xforceplus.ultraman.app.sdktest.service.IAppLevel2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AppLevel2Controller {

  @Autowired
  private IAppLevel2Service appLevel2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appLevel2 ${table.comment}
   * @return
   */
  @GetMapping("/applevel2s" )
  public XfR getAppLevel2s(XfPage page, AppLevel2 appLevel2) {
    return XfR.ok(appLevel2ServiceImpl.page(page, Wrappers.query(appLevel2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/applevel2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appLevel2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param appLevel2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/applevel2s")
  public XfR save(@RequestBody AppLevel2 appLevel2) {
     return XfR.ok(appLevel2ServiceImpl.save(appLevel2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param appLevel2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/applevel2s/{id}")
  public XfR putUpdate(@RequestBody AppLevel2 appLevel2,@PathVariable Long id) {
      appLevel2.setId(id);
      return XfR.ok(appLevel2ServiceImpl.updateById(appLevel2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param appLevel2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/applevel2s/{id}")
  public XfR patchUpdate(@RequestBody AppLevel2 appLevel2,@PathVariable Long id) {
      AppLevel2 upappLevel2 = appLevel2ServiceImpl.getById(id);
      if(upappLevel2 != null){
        upappLevel2 = ObjectCopyUtils.copyProperties(appLevel2,upappLevel2,true);
      }
      return XfR.ok(appLevel2ServiceImpl.updateById(upappLevel2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applevel2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appLevel2ServiceImpl.removeById(id));
  }

  @PostMapping("/applevel2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_level2");
     params.put("request", condition);

     return XfR.ok(appLevel2ServiceImpl.querys(params));
  }

}
