package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.AppLevel3;
import com.xforceplus.ultraman.app.sdktest.service.IAppLevel3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AppLevel3Controller {

  @Autowired
  private IAppLevel3Service appLevel3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appLevel3 ${table.comment}
   * @return
   */
  @GetMapping("/applevel3s" )
  public XfR getAppLevel3s(XfPage page, AppLevel3 appLevel3) {
    return XfR.ok(appLevel3ServiceImpl.page(page, Wrappers.query(appLevel3)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/applevel3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appLevel3ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param appLevel3 ${table.comment}
   * @return XfR
   */
  @PostMapping("/applevel3s")
  public XfR save(@RequestBody AppLevel3 appLevel3) {
     return XfR.ok(appLevel3ServiceImpl.save(appLevel3));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param appLevel3 ${table.comment}
   * @return XfR
   */
  @PutMapping("/applevel3s/{id}")
  public XfR putUpdate(@RequestBody AppLevel3 appLevel3,@PathVariable Long id) {
      appLevel3.setId(id);
      return XfR.ok(appLevel3ServiceImpl.updateById(appLevel3));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param appLevel3 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/applevel3s/{id}")
  public XfR patchUpdate(@RequestBody AppLevel3 appLevel3,@PathVariable Long id) {
      AppLevel3 upappLevel3 = appLevel3ServiceImpl.getById(id);
      if(upappLevel3 != null){
        upappLevel3 = ObjectCopyUtils.copyProperties(appLevel3,upappLevel3,true);
      }
      return XfR.ok(appLevel3ServiceImpl.updateById(upappLevel3));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applevel3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appLevel3ServiceImpl.removeById(id));
  }

  @PostMapping("/applevel3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_level3");
     params.put("request", condition);

     return XfR.ok(appLevel3ServiceImpl.querys(params));
  }

}
