package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.AppLevel4;
import com.xforceplus.ultraman.app.sdktest.service.IAppLevel4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AppLevel4Controller {

  @Autowired
  private IAppLevel4Service appLevel4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param appLevel4 ${table.comment}
   * @return
   */
  @GetMapping("/applevel4s" )
  public XfR getAppLevel4s(XfPage page, AppLevel4 appLevel4) {
    return XfR.ok(appLevel4ServiceImpl.page(page, Wrappers.query(appLevel4)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/applevel4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(appLevel4ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param appLevel4 ${table.comment}
   * @return XfR
   */
  @PostMapping("/applevel4s")
  public XfR save(@RequestBody AppLevel4 appLevel4) {
     return XfR.ok(appLevel4ServiceImpl.save(appLevel4));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param appLevel4 ${table.comment}
   * @return XfR
   */
  @PutMapping("/applevel4s/{id}")
  public XfR putUpdate(@RequestBody AppLevel4 appLevel4,@PathVariable Long id) {
      appLevel4.setId(id);
      return XfR.ok(appLevel4ServiceImpl.updateById(appLevel4));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param appLevel4 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/applevel4s/{id}")
  public XfR patchUpdate(@RequestBody AppLevel4 appLevel4,@PathVariable Long id) {
      AppLevel4 upappLevel4 = appLevel4ServiceImpl.getById(id);
      if(upappLevel4 != null){
        upappLevel4 = ObjectCopyUtils.copyProperties(appLevel4,upappLevel4,true);
      }
      return XfR.ok(appLevel4ServiceImpl.updateById(upappLevel4));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/applevel4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(appLevel4ServiceImpl.removeById(id));
  }

  @PostMapping("/applevel4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "app_level4");
     params.put("request", condition);

     return XfR.ok(appLevel4ServiceImpl.querys(params));
  }

}
