package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Assetchild;
import com.xforceplus.ultraman.app.sdktest.service.IAssetchildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AssetchildController {

  @Autowired
  private IAssetchildService assetchildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param assetchild ${table.comment}
   * @return
   */
  @GetMapping("/assetchilds" )
  public XfR getAssetchilds(XfPage page, Assetchild assetchild) {
    return XfR.ok(assetchildServiceImpl.page(page, Wrappers.query(assetchild)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/assetchilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(assetchildServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param assetchild ${table.comment}
   * @return XfR
   */
  @PostMapping("/assetchilds")
  public XfR save(@RequestBody Assetchild assetchild) {
     return XfR.ok(assetchildServiceImpl.save(assetchild));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param assetchild ${table.comment}
   * @return XfR
   */
  @PutMapping("/assetchilds/{id}")
  public XfR putUpdate(@RequestBody Assetchild assetchild,@PathVariable Long id) {
      assetchild.setId(id);
      return XfR.ok(assetchildServiceImpl.updateById(assetchild));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param assetchild ${table.comment}
   * @return XfR
   */
  @PatchMapping("/assetchilds/{id}")
  public XfR patchUpdate(@RequestBody Assetchild assetchild,@PathVariable Long id) {
      Assetchild upassetchild = assetchildServiceImpl.getById(id);
      if(upassetchild != null){
        upassetchild = ObjectCopyUtils.copyProperties(assetchild,upassetchild,true);
      }
      return XfR.ok(assetchildServiceImpl.updateById(upassetchild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/assetchilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(assetchildServiceImpl.removeById(id));
  }

  @PostMapping("/assetchilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "assetchild");
     params.put("request", condition);

     return XfR.ok(assetchildServiceImpl.querys(params));
  }

}
