package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Assets;
import com.xforceplus.ultraman.app.sdktest.service.IAssetsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class AssetsController {

  @Autowired
  private IAssetsService assetsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param assets ${table.comment}
   * @return
   */
  @GetMapping("/assetss" )
  public XfR getAssetss(XfPage page, Assets assets) {
    return XfR.ok(assetsServiceImpl.page(page, Wrappers.query(assets)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/assetss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(assetsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param assets ${table.comment}
   * @return XfR
   */
  @PostMapping("/assetss")
  public XfR save(@RequestBody Assets assets) {
     return XfR.ok(assetsServiceImpl.save(assets));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param assets ${table.comment}
   * @return XfR
   */
  @PutMapping("/assetss/{id}")
  public XfR putUpdate(@RequestBody Assets assets,@PathVariable Long id) {
      assets.setId(id);
      return XfR.ok(assetsServiceImpl.updateById(assets));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param assets ${table.comment}
   * @return XfR
   */
  @PatchMapping("/assetss/{id}")
  public XfR patchUpdate(@RequestBody Assets assets,@PathVariable Long id) {
      Assets upassets = assetsServiceImpl.getById(id);
      if(upassets != null){
        upassets = ObjectCopyUtils.copyProperties(assets,upassets,true);
      }
      return XfR.ok(assetsServiceImpl.updateById(upassets));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/assetss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(assetsServiceImpl.removeById(id));
  }

  @PostMapping("/assetss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "${table.name}");
     params.put("request", condition);

     return XfR.ok(assetsServiceImpl.querys(params));
  }

}
