package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.BPerson;
import com.xforceplus.ultraman.app.sdktest.service.IBPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BPersonController {

  @Autowired
  private IBPersonService BPersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bPerson ${table.comment}
   * @return
   */
  @GetMapping("/bpersons" )
  public XfR getBPersons(XfPage page, BPerson bPerson) {
    return XfR.ok(BPersonServiceImpl.page(page, Wrappers.query(bPerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bpersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(BPersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bPerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/bpersons")
  public XfR save(@RequestBody BPerson bPerson) {
     return XfR.ok(BPersonServiceImpl.save(bPerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bPerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/bpersons/{id}")
  public XfR putUpdate(@RequestBody BPerson bPerson,@PathVariable Long id) {
      bPerson.setId(id);
      return XfR.ok(BPersonServiceImpl.updateById(bPerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bPerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bpersons/{id}")
  public XfR patchUpdate(@RequestBody BPerson bPerson,@PathVariable Long id) {
      BPerson upbPerson = BPersonServiceImpl.getById(id);
      if(upbPerson != null){
        upbPerson = ObjectCopyUtils.copyProperties(bPerson,upbPerson,true);
      }
      return XfR.ok(BPersonServiceImpl.updateById(upbPerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bpersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(BPersonServiceImpl.removeById(id));
  }

  @PostMapping("/bpersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "b_person");
     params.put("request", condition);

     return XfR.ok(BPersonServiceImpl.querys(params));
  }

}
