package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.BigPerson;
import com.xforceplus.ultraman.app.sdktest.service.IBigPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BigPersonController {

  @Autowired
  private IBigPersonService bigPersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bigPerson ${table.comment}
   * @return
   */
  @GetMapping("/bigpersons" )
  public XfR getBigPersons(XfPage page, BigPerson bigPerson) {
    return XfR.ok(bigPersonServiceImpl.page(page, Wrappers.query(bigPerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bigpersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bigPersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bigPerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/bigpersons")
  public XfR save(@RequestBody BigPerson bigPerson) {
     return XfR.ok(bigPersonServiceImpl.save(bigPerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bigPerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/bigpersons/{id}")
  public XfR putUpdate(@RequestBody BigPerson bigPerson,@PathVariable Long id) {
      bigPerson.setId(id);
      return XfR.ok(bigPersonServiceImpl.updateById(bigPerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bigPerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bigpersons/{id}")
  public XfR patchUpdate(@RequestBody BigPerson bigPerson,@PathVariable Long id) {
      BigPerson upbigPerson = bigPersonServiceImpl.getById(id);
      if(upbigPerson != null){
        upbigPerson = ObjectCopyUtils.copyProperties(bigPerson,upbigPerson,true);
      }
      return XfR.ok(bigPersonServiceImpl.updateById(upbigPerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bigpersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bigPersonServiceImpl.removeById(id));
  }

  @PostMapping("/bigpersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "big_person");
     params.put("request", condition);

     return XfR.ok(bigPersonServiceImpl.querys(params));
  }

}
