package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.BocpP1;
import com.xforceplus.ultraman.app.sdktest.service.IBocpP1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BocpP1Controller {

  @Autowired
  private IBocpP1Service bocpP1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bocpP1 ${table.comment}
   * @return
   */
  @GetMapping("/bocpp1s" )
  public XfR getBocpP1s(XfPage page, BocpP1 bocpP1) {
    return XfR.ok(bocpP1ServiceImpl.page(page, Wrappers.query(bocpP1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bocpp1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bocpP1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bocpP1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/bocpp1s")
  public XfR save(@RequestBody BocpP1 bocpP1) {
     return XfR.ok(bocpP1ServiceImpl.save(bocpP1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bocpP1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/bocpp1s/{id}")
  public XfR putUpdate(@RequestBody BocpP1 bocpP1,@PathVariable Long id) {
      bocpP1.setId(id);
      return XfR.ok(bocpP1ServiceImpl.updateById(bocpP1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bocpP1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bocpp1s/{id}")
  public XfR patchUpdate(@RequestBody BocpP1 bocpP1,@PathVariable Long id) {
      BocpP1 upbocpP1 = bocpP1ServiceImpl.getById(id);
      if(upbocpP1 != null){
        upbocpP1 = ObjectCopyUtils.copyProperties(bocpP1,upbocpP1,true);
      }
      return XfR.ok(bocpP1ServiceImpl.updateById(upbocpP1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bocpp1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bocpP1ServiceImpl.removeById(id));
  }

  @PostMapping("/bocpp1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bocp_p1");
     params.put("request", condition);

     return XfR.ok(bocpP1ServiceImpl.querys(params));
  }

}
