package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.BocpP2;
import com.xforceplus.ultraman.app.sdktest.service.IBocpP2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BocpP2Controller {

  @Autowired
  private IBocpP2Service bocpP2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bocpP2 ${table.comment}
   * @return
   */
  @GetMapping("/bocpp2s" )
  public XfR getBocpP2s(XfPage page, BocpP2 bocpP2) {
    return XfR.ok(bocpP2ServiceImpl.page(page, Wrappers.query(bocpP2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bocpp2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bocpP2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bocpP2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/bocpp2s")
  public XfR save(@RequestBody BocpP2 bocpP2) {
     return XfR.ok(bocpP2ServiceImpl.save(bocpP2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bocpP2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/bocpp2s/{id}")
  public XfR putUpdate(@RequestBody BocpP2 bocpP2,@PathVariable Long id) {
      bocpP2.setId(id);
      return XfR.ok(bocpP2ServiceImpl.updateById(bocpP2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bocpP2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bocpp2s/{id}")
  public XfR patchUpdate(@RequestBody BocpP2 bocpP2,@PathVariable Long id) {
      BocpP2 upbocpP2 = bocpP2ServiceImpl.getById(id);
      if(upbocpP2 != null){
        upbocpP2 = ObjectCopyUtils.copyProperties(bocpP2,upbocpP2,true);
      }
      return XfR.ok(bocpP2ServiceImpl.updateById(upbocpP2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bocpp2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bocpP2ServiceImpl.removeById(id));
  }

  @PostMapping("/bocpp2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bocp_p2");
     params.put("request", condition);

     return XfR.ok(bocpP2ServiceImpl.querys(params));
  }

}
