package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.BussinessParent;
import com.xforceplus.ultraman.app.sdktest.service.IBussinessParentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BussinessParentController {

  @Autowired
  private IBussinessParentService bussinessParentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bussinessParent ${table.comment}
   * @return
   */
  @GetMapping("/bussinessparents" )
  public XfR getBussinessParents(XfPage page, BussinessParent bussinessParent) {
    return XfR.ok(bussinessParentServiceImpl.page(page, Wrappers.query(bussinessParent)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bussinessparents/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bussinessParentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bussinessParent ${table.comment}
   * @return XfR
   */
  @PostMapping("/bussinessparents")
  public XfR save(@RequestBody BussinessParent bussinessParent) {
     return XfR.ok(bussinessParentServiceImpl.save(bussinessParent));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bussinessParent ${table.comment}
   * @return XfR
   */
  @PutMapping("/bussinessparents/{id}")
  public XfR putUpdate(@RequestBody BussinessParent bussinessParent,@PathVariable Long id) {
      bussinessParent.setId(id);
      return XfR.ok(bussinessParentServiceImpl.updateById(bussinessParent));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bussinessParent ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bussinessparents/{id}")
  public XfR patchUpdate(@RequestBody BussinessParent bussinessParent,@PathVariable Long id) {
      BussinessParent upbussinessParent = bussinessParentServiceImpl.getById(id);
      if(upbussinessParent != null){
        upbussinessParent = ObjectCopyUtils.copyProperties(bussinessParent,upbussinessParent,true);
      }
      return XfR.ok(bussinessParentServiceImpl.updateById(upbussinessParent));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bussinessparents/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bussinessParentServiceImpl.removeById(id));
  }

  @PostMapping("/bussinessparents/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bussiness_parent");
     params.put("request", condition);

     return XfR.ok(bussinessParentServiceImpl.querys(params));
  }

}
