package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.CPerson;
import com.xforceplus.ultraman.app.sdktest.service.ICPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class CPersonController {

  @Autowired
  private ICPersonService CPersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cPerson ${table.comment}
   * @return
   */
  @GetMapping("/cpersons" )
  public XfR getCPersons(XfPage page, CPerson cPerson) {
    return XfR.ok(CPersonServiceImpl.page(page, Wrappers.query(cPerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cpersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(CPersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cPerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/cpersons")
  public XfR save(@RequestBody CPerson cPerson) {
     return XfR.ok(CPersonServiceImpl.save(cPerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cPerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/cpersons/{id}")
  public XfR putUpdate(@RequestBody CPerson cPerson,@PathVariable Long id) {
      cPerson.setId(id);
      return XfR.ok(CPersonServiceImpl.updateById(cPerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cPerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cpersons/{id}")
  public XfR patchUpdate(@RequestBody CPerson cPerson,@PathVariable Long id) {
      CPerson upcPerson = CPersonServiceImpl.getById(id);
      if(upcPerson != null){
        upcPerson = ObjectCopyUtils.copyProperties(cPerson,upcPerson,true);
      }
      return XfR.ok(CPersonServiceImpl.updateById(upcPerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cpersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(CPersonServiceImpl.removeById(id));
  }

  @PostMapping("/cpersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "c_person");
     params.put("request", condition);

     return XfR.ok(CPersonServiceImpl.querys(params));
  }

}
