package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Child;
import com.xforceplus.ultraman.app.sdktest.service.IChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildController {

  @Autowired
  private IChildService childServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param child ${table.comment}
   * @return
   */
  @GetMapping("/childs" )
  public XfR getChilds(XfPage page, Child child) {
    return XfR.ok(childServiceImpl.page(page, Wrappers.query(child)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param child ${table.comment}
   * @return XfR
   */
  @PostMapping("/childs")
  public XfR save(@RequestBody Child child) {
     return XfR.ok(childServiceImpl.save(child));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param child ${table.comment}
   * @return XfR
   */
  @PutMapping("/childs/{id}")
  public XfR putUpdate(@RequestBody Child child,@PathVariable Long id) {
      child.setId(id);
      return XfR.ok(childServiceImpl.updateById(child));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param child ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childs/{id}")
  public XfR patchUpdate(@RequestBody Child child,@PathVariable Long id) {
      Child upchild = childServiceImpl.getById(id);
      if(upchild != null){
        upchild = ObjectCopyUtils.copyProperties(child,upchild,true);
      }
      return XfR.ok(childServiceImpl.updateById(upchild));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childServiceImpl.removeById(id));
  }

  @PostMapping("/childs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child");
     params.put("request", condition);

     return XfR.ok(childServiceImpl.querys(params));
  }

}
