package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ChildOqs25536;
import com.xforceplus.ultraman.app.sdktest.service.IChildOqs25536Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildOqs25536Controller {

  @Autowired
  private IChildOqs25536Service childOqs25536ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param childOqs25536 ${table.comment}
   * @return
   */
  @GetMapping("/childoqs25536s" )
  public XfR getChildOqs25536s(XfPage page, ChildOqs25536 childOqs25536) {
    return XfR.ok(childOqs25536ServiceImpl.page(page, Wrappers.query(childOqs25536)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childoqs25536s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childOqs25536ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param childOqs25536 ${table.comment}
   * @return XfR
   */
  @PostMapping("/childoqs25536s")
  public XfR save(@RequestBody ChildOqs25536 childOqs25536) {
     return XfR.ok(childOqs25536ServiceImpl.save(childOqs25536));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param childOqs25536 ${table.comment}
   * @return XfR
   */
  @PutMapping("/childoqs25536s/{id}")
  public XfR putUpdate(@RequestBody ChildOqs25536 childOqs25536,@PathVariable Long id) {
      childOqs25536.setId(id);
      return XfR.ok(childOqs25536ServiceImpl.updateById(childOqs25536));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param childOqs25536 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childoqs25536s/{id}")
  public XfR patchUpdate(@RequestBody ChildOqs25536 childOqs25536,@PathVariable Long id) {
      ChildOqs25536 upchildOqs25536 = childOqs25536ServiceImpl.getById(id);
      if(upchildOqs25536 != null){
        upchildOqs25536 = ObjectCopyUtils.copyProperties(childOqs25536,upchildOqs25536,true);
      }
      return XfR.ok(childOqs25536ServiceImpl.updateById(upchildOqs25536));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childoqs25536s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childOqs25536ServiceImpl.removeById(id));
  }

  @PostMapping("/childoqs25536s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child_oqs25536");
     params.put("request", condition);

     return XfR.ok(childOqs25536ServiceImpl.querys(params));
  }

}
