package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ChildOqs4579;
import com.xforceplus.ultraman.app.sdktest.service.IChildOqs4579Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildOqs4579Controller {

  @Autowired
  private IChildOqs4579Service childOqs4579ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param childOqs4579 ${table.comment}
   * @return
   */
  @GetMapping("/childoqs4579s" )
  public XfR getChildOqs4579s(XfPage page, ChildOqs4579 childOqs4579) {
    return XfR.ok(childOqs4579ServiceImpl.page(page, Wrappers.query(childOqs4579)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childoqs4579s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childOqs4579ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param childOqs4579 ${table.comment}
   * @return XfR
   */
  @PostMapping("/childoqs4579s")
  public XfR save(@RequestBody ChildOqs4579 childOqs4579) {
     return XfR.ok(childOqs4579ServiceImpl.save(childOqs4579));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param childOqs4579 ${table.comment}
   * @return XfR
   */
  @PutMapping("/childoqs4579s/{id}")
  public XfR putUpdate(@RequestBody ChildOqs4579 childOqs4579,@PathVariable Long id) {
      childOqs4579.setId(id);
      return XfR.ok(childOqs4579ServiceImpl.updateById(childOqs4579));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param childOqs4579 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childoqs4579s/{id}")
  public XfR patchUpdate(@RequestBody ChildOqs4579 childOqs4579,@PathVariable Long id) {
      ChildOqs4579 upchildOqs4579 = childOqs4579ServiceImpl.getById(id);
      if(upchildOqs4579 != null){
        upchildOqs4579 = ObjectCopyUtils.copyProperties(childOqs4579,upchildOqs4579,true);
      }
      return XfR.ok(childOqs4579ServiceImpl.updateById(upchildOqs4579));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childoqs4579s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childOqs4579ServiceImpl.removeById(id));
  }

  @PostMapping("/childoqs4579s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child_oqs4579");
     params.put("request", condition);

     return XfR.ok(childOqs4579ServiceImpl.querys(params));
  }

}
