package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ChildTest3;
import com.xforceplus.ultraman.app.sdktest.service.IChildTest3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildTest3Controller {

  @Autowired
  private IChildTest3Service childTest3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param childTest3 ${table.comment}
   * @return
   */
  @GetMapping("/childtest3s" )
  public XfR getChildTest3s(XfPage page, ChildTest3 childTest3) {
    return XfR.ok(childTest3ServiceImpl.page(page, Wrappers.query(childTest3)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childtest3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childTest3ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param childTest3 ${table.comment}
   * @return XfR
   */
  @PostMapping("/childtest3s")
  public XfR save(@RequestBody ChildTest3 childTest3) {
     return XfR.ok(childTest3ServiceImpl.save(childTest3));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param childTest3 ${table.comment}
   * @return XfR
   */
  @PutMapping("/childtest3s/{id}")
  public XfR putUpdate(@RequestBody ChildTest3 childTest3,@PathVariable Long id) {
      childTest3.setId(id);
      return XfR.ok(childTest3ServiceImpl.updateById(childTest3));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param childTest3 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childtest3s/{id}")
  public XfR patchUpdate(@RequestBody ChildTest3 childTest3,@PathVariable Long id) {
      ChildTest3 upchildTest3 = childTest3ServiceImpl.getById(id);
      if(upchildTest3 != null){
        upchildTest3 = ObjectCopyUtils.copyProperties(childTest3,upchildTest3,true);
      }
      return XfR.ok(childTest3ServiceImpl.updateById(upchildTest3));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childtest3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childTest3ServiceImpl.removeById(id));
  }

  @PostMapping("/childtest3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child_test3");
     params.put("request", condition);

     return XfR.ok(childTest3ServiceImpl.querys(params));
  }

}
