package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ChildTest4;
import com.xforceplus.ultraman.app.sdktest.service.IChildTest4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildTest4Controller {

  @Autowired
  private IChildTest4Service childTest4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param childTest4 ${table.comment}
   * @return
   */
  @GetMapping("/childtest4s" )
  public XfR getChildTest4s(XfPage page, ChildTest4 childTest4) {
    return XfR.ok(childTest4ServiceImpl.page(page, Wrappers.query(childTest4)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childtest4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childTest4ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param childTest4 ${table.comment}
   * @return XfR
   */
  @PostMapping("/childtest4s")
  public XfR save(@RequestBody ChildTest4 childTest4) {
     return XfR.ok(childTest4ServiceImpl.save(childTest4));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param childTest4 ${table.comment}
   * @return XfR
   */
  @PutMapping("/childtest4s/{id}")
  public XfR putUpdate(@RequestBody ChildTest4 childTest4,@PathVariable Long id) {
      childTest4.setId(id);
      return XfR.ok(childTest4ServiceImpl.updateById(childTest4));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param childTest4 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childtest4s/{id}")
  public XfR patchUpdate(@RequestBody ChildTest4 childTest4,@PathVariable Long id) {
      ChildTest4 upchildTest4 = childTest4ServiceImpl.getById(id);
      if(upchildTest4 != null){
        upchildTest4 = ObjectCopyUtils.copyProperties(childTest4,upchildTest4,true);
      }
      return XfR.ok(childTest4ServiceImpl.updateById(upchildTest4));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childtest4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childTest4ServiceImpl.removeById(id));
  }

  @PostMapping("/childtest4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child_test4");
     params.put("request", condition);

     return XfR.ok(childTest4ServiceImpl.querys(params));
  }

}
