package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.ChildTest;
import com.xforceplus.ultraman.app.sdktest.service.IChildTestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ChildTestController {

  @Autowired
  private IChildTestService childTestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param childTest ${table.comment}
   * @return
   */
  @GetMapping("/childtests" )
  public XfR getChildTests(XfPage page, ChildTest childTest) {
    return XfR.ok(childTestServiceImpl.page(page, Wrappers.query(childTest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/childtests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(childTestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param childTest ${table.comment}
   * @return XfR
   */
  @PostMapping("/childtests")
  public XfR save(@RequestBody ChildTest childTest) {
     return XfR.ok(childTestServiceImpl.save(childTest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param childTest ${table.comment}
   * @return XfR
   */
  @PutMapping("/childtests/{id}")
  public XfR putUpdate(@RequestBody ChildTest childTest,@PathVariable Long id) {
      childTest.setId(id);
      return XfR.ok(childTestServiceImpl.updateById(childTest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param childTest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/childtests/{id}")
  public XfR patchUpdate(@RequestBody ChildTest childTest,@PathVariable Long id) {
      ChildTest upchildTest = childTestServiceImpl.getById(id);
      if(upchildTest != null){
        upchildTest = ObjectCopyUtils.copyProperties(childTest,upchildTest,true);
      }
      return XfR.ok(childTestServiceImpl.updateById(upchildTest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/childtests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(childTestServiceImpl.removeById(id));
  }

  @PostMapping("/childtests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "child_test");
     params.put("request", condition);

     return XfR.ok(childTestServiceImpl.querys(params));
  }

}
