package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.DPerson;
import com.xforceplus.ultraman.app.sdktest.service.IDPersonService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class DPersonController {

  @Autowired
  private IDPersonService DPersonServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dPerson ${table.comment}
   * @return
   */
  @GetMapping("/dpersons" )
  public XfR getDPersons(XfPage page, DPerson dPerson) {
    return XfR.ok(DPersonServiceImpl.page(page, Wrappers.query(dPerson)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dpersons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(DPersonServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dPerson ${table.comment}
   * @return XfR
   */
  @PostMapping("/dpersons")
  public XfR save(@RequestBody DPerson dPerson) {
     return XfR.ok(DPersonServiceImpl.save(dPerson));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dPerson ${table.comment}
   * @return XfR
   */
  @PutMapping("/dpersons/{id}")
  public XfR putUpdate(@RequestBody DPerson dPerson,@PathVariable Long id) {
      dPerson.setId(id);
      return XfR.ok(DPersonServiceImpl.updateById(dPerson));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dPerson ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dpersons/{id}")
  public XfR patchUpdate(@RequestBody DPerson dPerson,@PathVariable Long id) {
      DPerson updPerson = DPersonServiceImpl.getById(id);
      if(updPerson != null){
        updPerson = ObjectCopyUtils.copyProperties(dPerson,updPerson,true);
      }
      return XfR.ok(DPersonServiceImpl.updateById(updPerson));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dpersons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(DPersonServiceImpl.removeById(id));
  }

  @PostMapping("/dpersons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "d_person");
     params.put("request", condition);

     return XfR.ok(DPersonServiceImpl.querys(params));
  }

}
