package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Dddtest;
import com.xforceplus.ultraman.app.sdktest.service.IDddtestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class DddtestController {

  @Autowired
  private IDddtestService dddtestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dddtest ${table.comment}
   * @return
   */
  @GetMapping("/dddtests" )
  public XfR getDddtests(XfPage page, Dddtest dddtest) {
    return XfR.ok(dddtestServiceImpl.page(page, Wrappers.query(dddtest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dddtests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dddtestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dddtest ${table.comment}
   * @return XfR
   */
  @PostMapping("/dddtests")
  public XfR save(@RequestBody Dddtest dddtest) {
     return XfR.ok(dddtestServiceImpl.save(dddtest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dddtest ${table.comment}
   * @return XfR
   */
  @PutMapping("/dddtests/{id}")
  public XfR putUpdate(@RequestBody Dddtest dddtest,@PathVariable Long id) {
      dddtest.setId(id);
      return XfR.ok(dddtestServiceImpl.updateById(dddtest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dddtest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dddtests/{id}")
  public XfR patchUpdate(@RequestBody Dddtest dddtest,@PathVariable Long id) {
      Dddtest updddtest = dddtestServiceImpl.getById(id);
      if(updddtest != null){
        updddtest = ObjectCopyUtils.copyProperties(dddtest,updddtest,true);
      }
      return XfR.ok(dddtestServiceImpl.updateById(updddtest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dddtests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dddtestServiceImpl.removeById(id));
  }

  @PostMapping("/dddtests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dddtest");
     params.put("request", condition);

     return XfR.ok(dddtestServiceImpl.querys(params));
  }

}
