package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Depart;
import com.xforceplus.ultraman.app.sdktest.service.IDepartService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class DepartController {

  @Autowired
  private IDepartService departServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param depart ${table.comment}
   * @return
   */
  @GetMapping("/departs" )
  public XfR getDeparts(XfPage page, Depart depart) {
    return XfR.ok(departServiceImpl.page(page, Wrappers.query(depart)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param depart ${table.comment}
   * @return XfR
   */
  @PostMapping("/departs")
  public XfR save(@RequestBody Depart depart) {
     return XfR.ok(departServiceImpl.save(depart));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param depart ${table.comment}
   * @return XfR
   */
  @PutMapping("/departs/{id}")
  public XfR putUpdate(@RequestBody Depart depart,@PathVariable Long id) {
      depart.setId(id);
      return XfR.ok(departServiceImpl.updateById(depart));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param depart ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departs/{id}")
  public XfR patchUpdate(@RequestBody Depart depart,@PathVariable Long id) {
      Depart updepart = departServiceImpl.getById(id);
      if(updepart != null){
        updepart = ObjectCopyUtils.copyProperties(depart,updepart,true);
      }
      return XfR.ok(departServiceImpl.updateById(updepart));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departServiceImpl.removeById(id));
  }

  @PostMapping("/departs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "depart");
     params.put("request", condition);

     return XfR.ok(departServiceImpl.querys(params));
  }

}
