package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Deploy;
import com.xforceplus.ultraman.app.sdktest.service.IDeployService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class DeployController {

  @Autowired
  private IDeployService deployServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deploy ${table.comment}
   * @return
   */
  @GetMapping("/deploys" )
  public XfR getDeploys(XfPage page, Deploy deploy) {
    return XfR.ok(deployServiceImpl.page(page, Wrappers.query(deploy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/deploys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deployServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param deploy ${table.comment}
   * @return XfR
   */
  @PostMapping("/deploys")
  public XfR save(@RequestBody Deploy deploy) {
     return XfR.ok(deployServiceImpl.save(deploy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param deploy ${table.comment}
   * @return XfR
   */
  @PutMapping("/deploys/{id}")
  public XfR putUpdate(@RequestBody Deploy deploy,@PathVariable Long id) {
      deploy.setId(id);
      return XfR.ok(deployServiceImpl.updateById(deploy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param deploy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/deploys/{id}")
  public XfR patchUpdate(@RequestBody Deploy deploy,@PathVariable Long id) {
      Deploy updeploy = deployServiceImpl.getById(id);
      if(updeploy != null){
        updeploy = ObjectCopyUtils.copyProperties(deploy,updeploy,true);
      }
      return XfR.ok(deployServiceImpl.updateById(updeploy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deploys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deployServiceImpl.removeById(id));
  }

  @PostMapping("/deploys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "deploy");
     params.put("request", condition);

     return XfR.ok(deployServiceImpl.querys(params));
  }

}
