package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.DiffAdd;
import com.xforceplus.ultraman.app.sdktest.service.IDiffAddService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class DiffAddController {

  @Autowired
  private IDiffAddService diffAddServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param diffAdd ${table.comment}
   * @return
   */
  @GetMapping("/diffadds" )
  public XfR getDiffAdds(XfPage page, DiffAdd diffAdd) {
    return XfR.ok(diffAddServiceImpl.page(page, Wrappers.query(diffAdd)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/diffadds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(diffAddServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param diffAdd ${table.comment}
   * @return XfR
   */
  @PostMapping("/diffadds")
  public XfR save(@RequestBody DiffAdd diffAdd) {
     return XfR.ok(diffAddServiceImpl.save(diffAdd));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param diffAdd ${table.comment}
   * @return XfR
   */
  @PutMapping("/diffadds/{id}")
  public XfR putUpdate(@RequestBody DiffAdd diffAdd,@PathVariable Long id) {
      diffAdd.setId(id);
      return XfR.ok(diffAddServiceImpl.updateById(diffAdd));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param diffAdd ${table.comment}
   * @return XfR
   */
  @PatchMapping("/diffadds/{id}")
  public XfR patchUpdate(@RequestBody DiffAdd diffAdd,@PathVariable Long id) {
      DiffAdd updiffAdd = diffAddServiceImpl.getById(id);
      if(updiffAdd != null){
        updiffAdd = ObjectCopyUtils.copyProperties(diffAdd,updiffAdd,true);
      }
      return XfR.ok(diffAddServiceImpl.updateById(updiffAdd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/diffadds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(diffAddServiceImpl.removeById(id));
  }

  @PostMapping("/diffadds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "diff_add");
     params.put("request", condition);

     return XfR.ok(diffAddServiceImpl.querys(params));
  }

}
